<?php
/**
 * DokuWiki Plugin hideindex (Action Component)
 * Bloque l'action "index" (plan du site) pour les anonymes.
 */

if (!defined('DOKU_INC')) die();

class action_plugin_hideindex extends DokuWiki_Action_Plugin
{
    public function register(Doku_Event_Handler $controller)
    {
        // Très tôt, avant que la page soit rendue
        $controller->register_hook('ACTION_ACT_PREPROCESS', 'BEFORE', $this, 'handle_act_preprocess');
    }

    public function handle_act_preprocess(Doku_Event $event, $param)
    {
        global $ACT, $USERINFO;

        // On ne touche qu'au plan du site
        if (!in_array($ACT, ['index', 'media', 'recent', 'search', 'backlink', 'revisions'], true)) {
                return;
        }

        // Si connecté -> OK
        if (!empty($USERINFO) && !empty($USERINFO['name'])) {
            return;
        }

        // Sinon -> refus net
        http_status(403);
        header('Content-Type: text/plain; charset=utf-8');
        echo "Accès refusé.";
        exit;
    }
}

